from mynumpy import *
from dists import mydist

# so you want a differentiable mapping from the unit box
# to the unit box that renders stuff non-independent?
mynorm = mydist(autograd.scipy.stats.norm,scipy.stats.norm)
mychi2 = mydist(autograd.scipy.stats.chi2,scipy.stats.chi2)

def icdf(omega,A,m):
    # first map to a standard Gaussian
    x = mynorm.ppf(omega)
    return A @ x + np.expand_dims(m,axis=1)

def circ(omega,A,m):
    # first map to a standard Gaussian
    assert(omega.shape[0]==2)
    r2 = mychi2.ppf(omega[1,:],2)
    r  = sqrt(r2)
    theta = omega[0,:]*2*pi
    x = vstack([r*cos(theta),r*sin(theta)])
    return A @ x + np.expand_dims(m,axis=1)
